/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.mixin.MekMixin;

import mekanism.api.Upgrade;
import mekanism.api.math.FloatingLong;
import mekanism.common.config.MekanismConfig;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.util.MekanismUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={MekanismUtils.class}, remap=false)
public class MekanismUtilMixin {
    @Overwrite
    public static double fractionUpgrades(IUpgradeTile tile, Upgrade type) {
        if (tile.supportsUpgrade(type)) {
            return (double)tile.getComponent().getUpgrades(type) / 8.0;
        }
        return 0.0;
    }

    @Overwrite
    public static FloatingLong getEnergyPerTick(IUpgradeTile tile, FloatingLong def) {
        return tile.supportsUpgrades() ? def.multiply(Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), 2.0 * MekanismUtilMixin.fractionUpgrades(tile, Upgrade.SPEED) - Math.min(MekanismUtilMixin.fractionUpgrades(tile, Upgrade.ENERGY), 1.0))) : def;
    }

    @Overwrite
    public static double getGasPerTickMeanMultiplier(IUpgradeTile tile) {
        if (tile.supportsUpgrades()) {
            double upgradeMul = MekanismUtilMixin.fractionUpgrades(tile, Upgrade.SPEED);
            double gasMul = MekanismUtilMixin.fractionUpgrades(tile, Upgrade.GAS);
            if (upgradeMul <= 1.0) {
                return tile.supportsUpgrade(Upgrade.GAS) ? Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), 2.0 * upgradeMul - gasMul) : Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), upgradeMul);
            }
            return tile.supportsUpgrade(Upgrade.GAS) ? Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), 2.0 * upgradeMul - gasMul * upgradeMul) : Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), upgradeMul);
        }
        return 1.0;
    }
}

